#!/bin/sh


SUUSET="$1"
KERNEL="$2"
ROOT="$3"
APP="$4"
TRDAPP="$5"
BGAN="$6"
FWVER="$7"

echo "suuset: $SUUSET kernel: $KERNEL root: $ROOT app: $APP 3rdapp: $TRDAPP bgan: $BGAN fwver: $FWVER"

PLATFORM="`cat /tmp/platform`"

if [ "$PLATFORM" == "tt3646" ]; then
    ln -fs /app/etc/fw_env_tt3646.config /tmp/fw_env.config

    fw_setenv suu "SUUSET=$SUUSET SUUMNT=mtdblock$APP,app,squashfs;mtdblock$TRDAPP,3rdapp,squashfs;mtdblock$BGAN,bgan,squashfs;"
    fw_setenv pttmu_root "root=/dev/mtdblock$ROOT ro"
    fw_setenv pttmu_firmwareversion "FIRMWARE=$FWVER"

    if [ "$KERNEL" == "7" ]; then
        fw_setenv nbootscript "nboot 82000000 nand0 \${SKERNEL} bootm;"

    elif [ "$KERNEL" == "11" ]; then
        fw_setenv nbootscript "nboot 82000000 nand0 \${KERNEL1}; bootm;"

    elif [ "$KERNEL" == "15" ]; then
        fw_setenv nbootscript "nboot 82000000 nand0 \${KERNEL2}; bootm;"

    else
        echo "Unknown kernel, abort."
        exit 1
    fi;
else
    ln -fs /app/etc/fw_env_tt3647.config /tmp/fw_env.config

    fw_setenv suu "SUUSET=$SUUSET SUUMNT=mmcblk0p$APP,app,squashfs;mmcblk0p$TRDAPP,3rdapp,squashfs;mmcblk0p$BGAN,bgan,squashfs;"
    fw_setenv pttmu_root "root=/dev/mmcblk0p$ROOT ro"
    fw_setenv pttmu_mmc_load "mmc init; fatload mmc 0:2 0x82000000 uimage$KERNEL"
    fw_setenv pttmu_bootargs "setenv bootargs console=ttyO2,115200 \${pttmu_root} \${pttmu_firmwareversion} \${suu} nohlt mtdparts=omap2-nand.0:128k@2432k(uboot-env)"
    fw_setenv pttmu_boot "run pttmu_mmc_load;run pttmu_bootargs;bootm 0x82000000"
    fw_setenv pttmu_firmwareversion "FIRMWARE=$FWVER"

    if [ -f /tmp/uImage ]; then
        mkdir /tmp/efi
        mount /dev/mmcblk0p2 /tmp/efi
        cp -f /tmp/uImage /tmp/efi/uImage$KERNEL
        umount /tmp/efi
        rm -f /tmp/uImage
        sync
    fi
fi;

prevcfg=`readlink /data/pttCURRENT | tr -d /data/ptt`

if [ ! -z "$prevcfg" ]; then
    rm -f /data/pttPREV
    if [ "$FWVER" == "2.00" ]; then
        # Remove pttCURRENT as it isnt reset in v2.00.
        # Dont set pttPREV as it isnt used by v2.00.
        rm /data/pttCURRENT
    else
        ln -s /data/ptt$prevcfg /data/pttPREV
    fi
fi
