#!/bin/sh

# Update script from USB-stick.
# This script is able to handle an upgrade from safeset when bgan partition
# has been made. The main problem is that the suu in safeset does not handle
# partition number in the set. It is just silently assumed that the partition
# number equals the set. The solve this problem a new suu/suup_activate is 
# required. To make this work, several variables needs to be set.

SUU=/tmp/usb/suu         # This is required for suu.

# Needed to set ld path, otherwise /app/lib/suup_activate.so is used.
# Note. Remeber to set the -plugin variable to suu.
export LD_LIBRARY_PATH=/tmp/usb/lib/
# New feature. reads in eiviroment variable ACTIVATE_SH, see below.
PLUGIN=suup_activate.so  

# ACTIVATE_SH. The activate.sh in safeset can not handle bgan partitons in
# housekeeping partitons (mmcblk0p5). The activate.sh must have support 
# for bgan partition.
export ACTIVATE_SH=/tmp/usb/activate.sh

echo "ptt-usb-install.sh loaded"

# TODO: If hostcfg is broken reinstall it
# Force rewrite of ptt.tiif into set 1

echo "Upgrading using script"

$SUU -plugin=$PLUGIN \
     -cfg=/dev/mmcblk0p5 install /tmp/usb/ptt.tiif 1 \
     -product=3647 -rewrite -f

reboot
